<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_slider_' . $id . '_settings', $settings);

$slider_settings = [
    'slide_animation' => $settings->slide_animation,
    'direction' => $settings->direction,
    'control_nav' => ('yes' === $settings->control_nav),
    'direction_nav' => ('yes' === $settings->direction_nav),
    'randomize' => ('yes' === $settings->randomize),
    'loop' => ('yes' === $settings->loop),
    'pause_on_hover' => ('yes' === $settings->pause_on_hover),
    'pause_on_action' => ('yes' === $settings->pause_on_action),
    'slideshow' => ('yes' === $settings->slideshow),
    'slideshow_speed' => absint($settings->slideshow_speed),
    'animation_speed' => absint($settings->animation_speed),
];

$output = '<div class="labb-slider labb-container ' . esc_attr($settings->class)
    . '" data-settings=\'' . wp_json_encode($slider_settings) . '\'>';

$output .= '<div class="labb-flexslider">';

$output .= '<div class="labb-slides">';

foreach ($settings->slides as $slide):

    if (!is_object($slide))
        continue;

    if (!empty($slide->slide_text)):

        $child_output = '<div class="labb-slide">';

        $child_output .= do_shortcode(wp_kses_post($slide->slide_text));

        $child_output .= '</div>';

        $output .= apply_filters('labb_slider_item_output', $child_output, $slide, $settings);

    endif;

endforeach;

$output .= '</div><!-- .labb-slide -->';

$output .= '</div><!-- .labb-slides -->';

$output .= '</div><!-- .labb-slider -->';

echo apply_filters('labb_slider_output', $output, $settings);